/*
 * Decompiled with CFR 0.152.
 */
package io.github.xcube16.iseedragons;

import com.google.common.collect.BiMap;
import io.github.xcube16.iseedragons.DefaultProxy;
import io.github.xcube16.iseedragons.FakeThirstStatHandler;
import io.github.xcube16.iseedragons.ISD;
import io.github.xcube16.iseedragons.StaticConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

@Mod(modid="iseedragons", version="1.2.1", acceptableRemoteVersions="*", name="ISeeDragons")
public class ISeeDragons {
    public static final String MODID = "iseedragons";
    public static final String NAME = "ISeeDragons";
    public static final String VERSION = "1.2.1";
    public static final Logger logger = ISD.logger;
    @Mod.Instance(value="iseedragons")
    private static ISeeDragons instance;
    @SidedProxy(clientSide="io.github.xcube16.iseedragons.client.ClientProxy", serverSide="io.github.xcube16.iseedragons.DefaultProxy")
    private static DefaultProxy proxy;
    @Nullable
    private Method dragonSetSleeping;
    @Nullable
    private Field dragonCurrentAnimation;
    @Nullable
    private Field dragonAnimationTick;
    @Nullable
    private Field dragon_ANIMATION_SHAKEPREY;
    @Nullable
    private Field cyclopsCurrentAnimation;
    @Nullable
    private Field cyclopsAnimationTick;
    @Nullable
    private Field cyclops_ANIMATION_EATPLAYER;
    private static Map<Block, Integer> dropChances;
    private static Map<Block, Integer> effectChances;
    private static final Set<ResourceLocation> unstoneableEntitys;
    private Map<Item, Float> extraUndeadDamage;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.loadConfig();
        logger.info("Fixing sea serpent armor repair...");
        try {
            Class<?> enumSeaSerpent = Class.forName("com.github.alexthe666.iceandfire.enums.EnumSeaSerpent");
            Object[] values = (Object[])enumSeaSerpent.getDeclaredMethod("values", new Class[0]).invoke(null, new Object[0]);
            Field armorMaterialField = enumSeaSerpent.getDeclaredField("armorMaterial");
            Field scaleField = enumSeaSerpent.getDeclaredField("scale");
            for (Object serpent : values) {
                ItemArmor.ArmorMaterial material = (ItemArmor.ArmorMaterial)armorMaterialField.get(serpent);
                material.setRepairItem(new ItemStack((Item)scaleField.get(serpent)));
                logger.info("Fixed " + material);
            }
        }
        catch (ClassNotFoundException e) {
            logger.warn("Could not find " + e.getMessage() + " while trying to fix sea serpent armor");
        }
        catch (Exception e) {
            logger.error("Failed to fix sea serpent armor", (Throwable)e);
        }
        logger.info("Fixing tools/armor repair listed in config...");
        StaticConfig.repairFixes.forEach((toolId, repairItem) -> {
            String[] split = repairItem.split(",");
            if (split.length == 1) {
                this.fixToolRepair((String)toolId, split[0], 0);
            } else if (split.length == 2) {
                this.fixToolRepair((String)toolId, split[0], Integer.parseInt(split[1]));
            } else {
                logger.error("Bad item string " + repairItem);
            }
        });
        if (StaticConfig.preventTANAttackEntityEvent && Loader.isModLoaded((String)"toughasnails")) {
            logger.info("Fixing TAN's attack entity event damage problem...");
            boolean found_listener = false;
            ConcurrentHashMap listeners = (ConcurrentHashMap)ReflectionHelper.getPrivateValue(EventBus.class, (Object)MinecraftForge.EVENT_BUS, (String[])new String[]{"listeners"});
            for (Map.Entry listener_entry : listeners.entrySet()) {
                if (!listener_entry.getKey().getClass().getName().equals("toughasnails.handler.thirst.ThirstStatHandler")) continue;
                found_listener = true;
                try {
                    MinecraftForge.EVENT_BUS.register((Object)new FakeThirstStatHandler(listener_entry.getKey()));
                }
                catch (Exception e) {
                    logger.error("Failed to initialize FakeThirstStatHandler");
                    e.printStackTrace();
                    break;
                }
                MinecraftForge.EVENT_BUS.unregister(listener_entry.getKey());
                break;
            }
            if (!found_listener) {
                logger.error("Could not find toughasnails ThirstStatHandler event listener");
            }
        }
    }

    private void fixToolRepair(String toolId, String repairItemId, int meta) {
        try {
            Item tool = Item.func_111206_d((String)toolId);
            if (tool == null) {
                logger.info("Could not find " + toolId + ", ignoring");
                return;
            }
            if (tool instanceof ItemTool) {
                Field toolMaterialField = ItemTool.class.getDeclaredField("field_77862_b");
                toolMaterialField.setAccessible(true);
                Object toolMaterial = toolMaterialField.get(tool);
                if (toolMaterial instanceof Item.ToolMaterial) {
                    Item repairItem = Item.func_111206_d((String)repairItemId);
                    if (repairItem != null) {
                        ((Item.ToolMaterial)toolMaterial).setRepairItem(new ItemStack(repairItem, 1, meta));
                        logger.info(toolId + " can now be repaired with " + repairItemId);
                    } else {
                        logger.error(repairItemId + " does not exist! Failed to fix " + toolId + " repair!");
                    }
                } else {
                    logger.error(toolId + " has a bad tool material of " + toolMaterial);
                }
            } else if (tool instanceof ItemArmor) {
                Field materialField = ItemArmor.class.getDeclaredField("field_77878_bZ");
                materialField.setAccessible(true);
                Object toolMaterial = materialField.get(tool);
                if (toolMaterial instanceof ItemArmor.ArmorMaterial) {
                    Item repairItem = Item.func_111206_d((String)repairItemId);
                    if (repairItem != null) {
                        ((ItemArmor.ArmorMaterial)toolMaterial).setRepairItem(new ItemStack(repairItem, 1, meta));
                        logger.info(toolId + " can now be repaired with " + repairItemId);
                    } else {
                        logger.error(repairItemId + " does not exist! Failed to fix " + toolId + " repair!");
                    }
                } else {
                    logger.error(toolId + " has a bad armor material of " + toolMaterial);
                }
            } else if (tool instanceof ItemSword) {
                Field materialField = ItemSword.class.getDeclaredField("field_150933_b");
                materialField.setAccessible(true);
                Object toolMaterial = materialField.get(tool);
                if (toolMaterial instanceof Item.ToolMaterial) {
                    Item repairItem = Item.func_111206_d((String)repairItemId);
                    if (repairItem != null) {
                        ((Item.ToolMaterial)toolMaterial).setRepairItem(new ItemStack(repairItem, 1, meta));
                        logger.info(toolId + " can now be repaired with " + repairItemId);
                    } else {
                        logger.error(repairItemId + " does not exist! Failed to fix " + toolId + " repair!");
                    }
                } else {
                    logger.error(toolId + " has a bad sword material of " + toolMaterial);
                }
            } else {
                logger.info(toolId + " is not a tool, armor, or sword");
            }
        }
        catch (Exception e) {
            logger.error("Critical error while fixing tool/armor repair for " + toolId, (Throwable)e);
        }
    }

    @SubscribeEvent
    public void lightningStruckEntity(EntityStruckByLightningEvent event) {
        if (StaticConfig.disableLightningItemDamage && event.getEntity() instanceof EntityItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerItems(RegistryEvent.Register<Item> event) {
        logger.info("Fixing Ice and Fire axes");
        OreDictionary.registerOre((String)"toolAxe", (Item)Item.func_111206_d((String)"iceandfire:dragonbone_axe"));
        OreDictionary.registerOre((String)"toolAxe", (Item)Item.func_111206_d((String)"iceandfire:myrmex_desert_axe"));
        OreDictionary.registerOre((String)"toolAxe", (Item)Item.func_111206_d((String)"iceandfire:myrmex_jungle_axe"));
        OreDictionary.registerOre((String)"toolAxe", (Item)Item.func_111206_d((String)"iceandfire:silver_axe"));
        logger.info("Fixing broken Ice and Fire OreDictionary entries. (all that ore dictionary spam that you can now ignore!)");
        OreDictionary.registerOre((String)"ingotSilver", (Item)Item.func_111206_d((String)"iceandfire:silver_ingot"));
        OreDictionary.registerOre((String)"nuggetSilver", (Item)Item.func_111206_d((String)"iceandfire:silver_nugget"));
        OreDictionary.registerOre((String)"oreSilver", (Item)Item.func_111206_d((String)"iceandfire:silver_ore"));
        OreDictionary.registerOre((String)"blockSilver", (Item)Item.func_111206_d((String)"iceandfire:silver_block"));
        OreDictionary.registerOre((String)"gemSapphire", (Item)Item.func_111206_d((String)"iceandfire:sapphire_gem"));
        OreDictionary.registerOre((String)"oreSapphire", (Item)Item.func_111206_d((String)"iceandfire:sapphire_ore"));
        OreDictionary.registerOre((String)"blockSapphire", (Item)Item.func_111206_d((String)"iceandfire:sapphire_block"));
        OreDictionary.registerOre((String)"boneWither", (Item)Item.func_111206_d((String)"iceandfire:witherbone"));
        OreDictionary.registerOre((String)"boneWithered", (Item)Item.func_111206_d((String)"iceandfire:witherbone"));
        OreDictionary.registerOre((String)"boneDragon", (Item)Item.func_111206_d((String)"iceandfire:dragonbone"));
        try {
            Class<?> enumSeaSerpent = Class.forName("com.github.alexthe666.iceandfire.enums.EnumSeaSerpent");
            Object[] values = (Object[])enumSeaSerpent.getDeclaredMethod("values", new Class[0]).invoke(null, new Object[0]);
            Field scaleField = enumSeaSerpent.getDeclaredField("scale");
            for (Object serpent : values) {
                OreDictionary.registerOre((String)"seaSerpentScales", (Item)((Item)scaleField.get(serpent)));
            }
        }
        catch (ClassNotFoundException e) {
            logger.warn("Could not find " + e.getMessage() + " while trying to fix sea serpent scales ore dictionary");
        }
        catch (Exception e) {
            logger.error("Failed register sea serpent scales in ore dictionary", (Throwable)e);
        }
        this.registerEgg(Item.func_111206_d((String)"iceandfire:hippogryph_egg"));
        this.registerEgg(Item.func_111206_d((String)"iceandfire:myrmex_jungle_egg"));
        this.registerEgg(Item.func_111206_d((String)"iceandfire:myrmex_desert_egg"));
        logger.info("Done fixing Ice and Fire ore dictionary");
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent e) {
        Float extra;
        ItemStack weapon;
        DamageSource source = e.getSource();
        if (e.getEntityLiving().func_70668_bt() != EnumCreatureAttribute.UNDEAD || source.func_94541_c() || source.func_76347_k() || source.func_82725_o() || source.func_76352_a() || !source.func_76355_l().equals("player") && !source.func_76355_l().equals("mob")) {
            return;
        }
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase && !(weapon = ((EntityLivingBase)source.func_76346_g()).func_184614_ca()).func_190926_b() && (extra = this.extraUndeadDamage.get(weapon.func_77973_b())) != null) {
            e.setAmount(e.getAmount() + extra.floatValue());
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
            this.loadConfig();
        }
    }

    private void loadConfig() {
        dropChances = this.loadBlockChanceMapping(StaticConfig.dropChances);
        effectChances = this.loadBlockChanceMapping(StaticConfig.effectChances);
        HashMap<Item, Float> extraUndeadDamage = new HashMap<Item, Float>();
        for (Map.Entry<String, Float> entry : StaticConfig.extraUndeadDamage.entrySet()) {
            Item weapon = Item.func_111206_d((String)entry.getKey());
            if (weapon != Items.field_190931_a) {
                extraUndeadDamage.put(weapon, entry.getValue());
                continue;
            }
            logger.warn(entry.getKey() + " was not found!");
        }
        this.extraUndeadDamage = extraUndeadDamage;
        if (StaticConfig.minBrightness > StaticConfig.maxBrightness) {
            logger.error("Min and max brightness are mixed up!");
            float min = StaticConfig.minBrightness;
            StaticConfig.minBrightness = StaticConfig.maxBrightness;
            StaticConfig.maxBrightness = min;
        }
        proxy.setBrightness(StaticConfig.minBrightness, StaticConfig.maxBrightness);
        unstoneableEntitys.clear();
        for (String str : StaticConfig.unstoneableEntitys) {
            unstoneableEntitys.add(new ResourceLocation(str));
        }
        logger.info("Scanning for Ice and Fire dragons...");
        boolean foundOne = false;
        try {
            Field regField = EntityRegistry.instance().getClass().getDeclaredField("entityClassRegistrations");
            regField.setAccessible(true);
            BiMap reg = (BiMap)regField.get(EntityRegistry.instance());
            for (EntityRegistry.EntityRegistration entity : reg.values()) {
                Optional<Integer> boost = this.getRenderBoost(entity.getRegistryName());
                if (!boost.isPresent()) continue;
                foundOne = true;
                logger.info("Fixed " + entity.getRegistryName() + " tracking distance");
                Field rangeField = entity.getClass().getDeclaredField("trackingRange");
                rangeField.setAccessible(true);
                rangeField.set(entity, boost.get());
            }
        }
        catch (Exception e) {
            logger.error("Failed to fix Ice and Fire entity tracking distance", (Throwable)e);
        }
        if (!foundOne) {
            logger.warn("No Ice and Fire dragons found! Is it installed?");
        }
    }

    private Map<Block, Integer> loadBlockChanceMapping(Map<String, Integer> input) {
        HashMap<Block, Integer> map = new HashMap<Block, Integer>();
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(entry.getKey()));
            if (block == Blocks.field_150350_a) {
                logger.warn("Could not find block \"" + entry.getKey() + "\", ignoring!");
                continue;
            }
            map.put(block, Math.min(Math.max(entry.getValue(), 0), 100));
        }
        return map;
    }

    public static boolean dragonBreakBlockHook(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        int chance = Optional.ofNullable(dropChances.get(block)).orElse(StaticConfig.defaultDropChance);
        boolean shouldDrop = true;
        if (chance == 0) {
            shouldDrop = false;
        } else if (chance != 100) {
            boolean bl = shouldDrop = world.field_73012_v.nextInt(100) < chance;
        }
        if (!block.isAir(state, (IBlockAccess)world, pos)) {
            chance = Optional.ofNullable(effectChances.get(block)).orElse(StaticConfig.defaultEffectChance);
            if (chance == 100 || chance != 0 && world.field_73012_v.nextInt(100) < chance) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            }
            if (shouldDrop) {
                block.func_176226_b(world, pos, state, 0);
            }
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        return true;
    }

    public static void dragonShakePrayHook(EntityTameable dragon, Entity prey, int animTick) {
        if (dragon.field_70170_p.field_72995_K) {
            return;
        }
        if (animTick == 56) {
            prey.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)dragon), prey instanceof EntityPlayer ? 17.0f : (float)dragon.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 4.0f);
        } else if (animTick > 60) {
            prey.func_184210_p();
        }
    }

    public static boolean canPlayerDismountHook(EntityPlayer player) {
        Entity mount = player.func_184187_bx();
        if (mount != null) {
            return instance.canDismount(mount);
        }
        return true;
    }

    public static ResourceLocation[] cleanAdvancementRequardsHook(ResourceLocation[] craftable) {
        return (ResourceLocation[])Arrays.stream(craftable).filter(item -> CraftingManager.func_193373_a((ResourceLocation)item) != null).toArray(ResourceLocation[]::new);
    }

    public static boolean iceAndFireGenerateHook(World world) {
        return Arrays.stream(StaticConfig.generatorBlacklist).noneMatch(i -> i == world.field_73011_w.getDimension());
    }

    public static boolean canStoneHook(Entity entity) {
        ResourceLocation id = EntityList.func_191301_a((Entity)entity);
        if (id == null) {
            return false;
        }
        return !unstoneableEntitys.contains(id);
    }

    private void registerEgg(Item egg) {
        OreDictionary.registerOre((String)"listAllEgg", (ItemStack)new ItemStack(egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"objectEgg", (ItemStack)new ItemStack(egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingredientEgg", (ItemStack)new ItemStack(egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodSimpleEgg", (ItemStack)new ItemStack(egg, 1, Short.MAX_VALUE));
    }

    @SubscribeEvent
    public void livingEntityAttacked(LivingAttackEvent e) {
        if (this.isDragon(e.getEntity()) && e.getAmount() > 0.0f) {
            try {
                if (this.dragonSetSleeping == null) {
                    this.dragonSetSleeping = this.getMethodInHierarchy(e.getEntity().getClass(), "setSleeping", Boolean.TYPE);
                    this.dragonSetSleeping.setAccessible(true);
                }
                this.dragonSetSleeping.invoke((Object)e.getEntity(), false);
            }
            catch (Exception ex) {
                logger.error("Failed to wake up Ice and Fire dragon", (Throwable)ex);
            }
        }
    }

    @SubscribeEvent
    public void onDismount(EntityMountEvent e) {
        if (!e.isCanceled() && e.getEntityMounting() instanceof EntityPlayer) {
            if (e.isDismounting()) {
                if (!this.canDismount(e.getEntityBeingMounted())) {
                    e.setCanceled(true);
                } else {
                    ((EntityPlayer)e.getEntityMounting()).func_70637_d(false);
                    this.handleDismount(e.getEntityBeingMounted(), e.getEntityMounting());
                }
            } else {
                Entity previousMount = e.getEntityMounting().func_184187_bx();
                if (previousMount != null) {
                    if (!this.canDismount(previousMount)) {
                        e.setCanceled(true);
                    } else {
                        this.handleDismount(previousMount, e.getEntityMounting());
                    }
                }
            }
        }
    }

    private boolean canDismount(Entity dragon) {
        if (dragon.field_70128_L || dragon instanceof EntityLivingBase && ((EntityLivingBase)dragon).func_110143_aJ() <= 0.0f) {
            return true;
        }
        if (this.isDragon(dragon)) {
            try {
                if (this.dragonCurrentAnimation == null) {
                    this.dragonCurrentAnimation = this.getFieldInHierarchy(dragon.getClass(), "currentAnimation");
                    this.dragonCurrentAnimation.setAccessible(true);
                }
                if (this.dragonAnimationTick == null) {
                    this.dragonAnimationTick = this.getFieldInHierarchy(dragon.getClass(), "animationTick");
                    this.dragonAnimationTick.setAccessible(true);
                }
                if (this.dragon_ANIMATION_SHAKEPREY == null) {
                    this.dragon_ANIMATION_SHAKEPREY = this.getFieldInHierarchy(dragon.getClass(), "ANIMATION_SHAKEPREY");
                }
                Object animation = this.dragonCurrentAnimation.get(dragon);
                Object aniShakePray = this.dragon_ANIMATION_SHAKEPREY.get(dragon);
                int aniTick = (Integer)this.dragonAnimationTick.get(dragon);
                if (animation == aniShakePray && aniTick <= 60) {
                    return false;
                }
            }
            catch (Exception ex) {
                logger.error("Failed to check dragon state", (Throwable)ex);
            }
        } else if (this.isCyclops(dragon)) {
            try {
                if (this.cyclopsCurrentAnimation == null) {
                    this.cyclopsCurrentAnimation = this.getFieldInHierarchy(dragon.getClass(), "currentAnimation");
                    this.cyclopsCurrentAnimation.setAccessible(true);
                }
                if (this.cyclopsAnimationTick == null) {
                    this.cyclopsAnimationTick = this.getFieldInHierarchy(dragon.getClass(), "animationTick");
                    this.cyclopsAnimationTick.setAccessible(true);
                }
                if (this.cyclops_ANIMATION_EATPLAYER == null) {
                    this.cyclops_ANIMATION_EATPLAYER = this.getFieldInHierarchy(dragon.getClass(), "ANIMATION_EATPLAYER");
                }
                Object animation = this.cyclopsCurrentAnimation.get(dragon);
                Object aniShakePray = this.cyclops_ANIMATION_EATPLAYER.get(dragon);
                int aniTick = (Integer)this.cyclopsAnimationTick.get(dragon);
                if (animation == aniShakePray && aniTick < 32) {
                    return false;
                }
            }
            catch (Exception ex) {
                logger.error("Failed to check cyclops state", (Throwable)ex);
            }
        }
        return true;
    }

    private void handleDismount(Entity mount, Entity rider) {
        if (mount.field_70128_L || mount instanceof EntityLivingBase && ((EntityLivingBase)mount).func_110143_aJ() <= 0.0f) {
            return;
        }
        if (this.isDragon(mount)) {
            try {
                Object aniShakePray;
                Object animation;
                if (this.dragonCurrentAnimation == null) {
                    this.dragonCurrentAnimation = this.getFieldInHierarchy(mount.getClass(), "currentAnimation");
                    this.dragonCurrentAnimation.setAccessible(true);
                }
                if (this.dragon_ANIMATION_SHAKEPREY == null) {
                    this.dragon_ANIMATION_SHAKEPREY = this.getFieldInHierarchy(mount.getClass(), "ANIMATION_SHAKEPREY");
                }
                if ((animation = this.dragonCurrentAnimation.get(mount)) == (aniShakePray = this.dragon_ANIMATION_SHAKEPREY.get(mount)) && !mount.field_70170_p.field_72995_K) {
                    float f = mount.func_70079_am();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error("Failed to check dragon state", (Throwable)ex);
            }
        }
    }

    private Optional<Integer> getRenderBoost(@Nullable ResourceLocation id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(StaticConfig.distanceOverrides.get(id.toString()));
    }

    private boolean isDragon(Entity entity) {
        ResourceLocation id = EntityList.func_191301_a((Entity)entity);
        if (id == null) {
            return false;
        }
        return id.func_110624_b().equals("iceandfire") && (id.func_110623_a().equals("icedragon") || id.func_110623_a().equals("firedragon"));
    }

    private boolean isCyclops(Entity entity) {
        ResourceLocation id = EntityList.func_191301_a((Entity)entity);
        if (id == null) {
            return false;
        }
        return id.func_110624_b().equals("iceandfire") && id.func_110623_a().equals("cyclops");
    }

    private Method getMethodInHierarchy(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null) {
                return this.getMethodInHierarchy(clazz.getSuperclass(), name, parameterTypes);
            }
            throw e;
        }
    }

    private Field getFieldInHierarchy(Class<?> clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return this.getFieldInHierarchy(clazz.getSuperclass(), name);
            }
            throw e;
        }
    }

    static {
        unstoneableEntitys = new HashSet<ResourceLocation>();
    }
}

